/*
** Copyright (c) 2000-2001 Matsushita Electric Industrial Co., Ltd.
** All Rights Reserved.
*/

#ifndef __SD_IOCTL_H__
#define __SD_IOCTL_H__


/*==============================================================
	J[hT[rXhCo@[J`
==============================================================*/
/***************************************/
/* e}N                          */
/***************************************/
#define SD_CS_MAJOR             (SD_CS_MAJOR_BASE+SD_MAJOR_CS)
#define SD_CS_MINOR             1
#define SD_CS_CLIENT_MAX        9	// J[hT[rXhCoOpen\ȃNCAghCo + hCoT[rX@
#define DEVICE_NAME "sd_cs"
//#define MEIDbg(fmt, args...) printk("SD-CS: Func=%s():Line=%d:" fmt "\n", __FUNCTION__ , __LINE__ , ## args)

/*=====================================================================
*** $Name	IRQ_WAIT
*** $Resume	荞ݑ҂\
*** $Desc	
*** $Note	
=====================================================================*/
typedef struct {
	wait_queue_head_t	queue;		// 荞ݑ҂L[
	ULONG			pending;	// 荞ݔtO
}IRQ_WAIT;

/*=====================================================================
*** $Name	MAKE_ERR
*** $Resume	G[R[hݒp\̃p[^
*** $Desc
*** $Note
=====================================================================*/
typedef struct {
	int	iCmd;		/* G[𔭐R}h */
	USHORT	usErr;		/* G[R[h */
} MAKE_ERR;

/***********************************************/
/*	SD I/F hCo                */
/***********************************************/
typedef struct {

	UCHAR   ucMMCFlag;		/* MMCJ[htO */
	UCHAR   ucSDFlag;		/* SDJ[htO */
	USHORT	unOutFlag;		/* J[hrotO */

	/* J[hEhCoŒlۑ */
	ULONG	ulCardAllSize;		/* SD Memory Card SZN^TCY(Sector) */
	ULONG	ulCardNormalSize;	/* SD Memory Card ʏ̈TCY(Sector) */
	USHORT	unWorkRAMSize;		/* Work RAM Size(Sector) */
	USHORT	unBufferRAMSize;	/* Buffer RAM Size(Sector) */
	USHORT	unAudioBufSize;		/* Audio Buffer Size(Sector) */
	USHORT	*punWorkRamAddr;	/* Work RAM address */

	/* Read/Writepp[^ */
	USHORT  unEndFlag;		/* R/W access all end 荞ݑ҂tO */
	USHORT	unRWIrqFlag;		/* Response end 荞ݑ҂tO */
	ULONG	ulSectorCount;		/* ]ZN^JEg */
	ULONG	ulRestSectorCount;	/* c]ZN^ */
	USHORT	unCardSectorSize;	/* 1ZN^TCYiDefault 512Byte) */
	USHORT	unAccessArea;		/* ANZẌw SD_SECURE_AREA:Fؗ̈@SD_NORMAL_AREA:ʏ̈ */
	USHORT	unStreamReadFlag;	/* Xg[[htO */

	USHORT	*punSDBufferAddr;	/* SD I/F Ring buffer address iǂݍ݃f[^obt@j*/
	USHORT	*punSDAudioBufferAddr;	/* SD-Audio Ring buffer address */

	USHORT	unUsbRWMode;		/* SD-USB W/R[h l */

	FS_INFO *pstrResultInfo;	/* Read/Writesʕۑp */

	USHORT  unIoCancelFlag;		/* LZtO */
	USHORT	unSearchFlag;		/* SearchwtO*/

	/* J[hEhCo */
	ULONG	ulCardStatus;		/* SD Card Status */
	USHORT	unCardErrStatus;	/* G[ (ʏG[lj*/
	USHORT	unSdifErrStatus;	/* SDI/F G[荞݃Xe[^X i荞݂̃G[opj*/
	USHORT	unSdioErrStatus;	/* SDIO TuG[Xe[^X */

	/* J[hEhCop[^ۑp */
	USHORT	unRCA;			/* RCAlۑp */
	USHORT	unCSD[8];		/* CSDlۑp */
	USHORT	unCID[8];		/* CIDlۑp 	*/
	USHORT	unSCR[4];		/* SD_SCRۑ */
	USHORT	unSD_SDSTATUS[32];	/* SD_STATUSlۑp */

/* 20120605 Delete */
/*
#if DMA_ON 
*/
#ifdef	DMA_ON
	/*--DMA֘A--*/
	STR_SDIF_DMAINFO	strDMAinfo;		/* DMA ] */
#endif /* DMA_ON */

#ifdef SDIO
/*----- SD I/O Driver Grobal variable ----------------------------*/
	USHORT	unIO_NumFunc;		/* Support IO card function Number */
	USHORT	unIO_MemPre;		/* IO card include memory function */
	ULONG	ulIO_Reg_IO_OCR;	/* IO OCR register */
	USHORT	unIO_SD_Rev;		/* SD Specification Revision */
	USHORT	unSDIO_Rev;		/* SD I/O Specification Revision */
	USHORT	unCCCR_Rev;		/* CCCR Revision */
	USHORT	unCCCR_Card_Capa;	/* CCCR Card Capability Register */
	
	USHORT	unIRQFlag;		/* SD I/O Interrupt occur flag */
	USHORT	unIOFlag;		/* SD I/O card kind flag */
	USHORT	unIOMaxBlockSize[8];	/* SD I/O max block size */
	USHORT	ucIOFuncCode[8];	/* SD I/O Function Code */
/**********SDIO荞݃R[obNsꍇ͈ȉLɂ***************/
/*	void	(*pvIOCallbackIrq)(void);*/	/* SD I/O callback֐address*/
/*****************************************************************************/
#endif /*SDIO*/

	struct semaphore	client_sem;	// Z}tH
	struct semaphore	peri_sem;	// hCorpZ}tH
	IRQ_WAIT		irq_wait;	// 荞ݑ҂
	ULONG			open_cnt;	// I[vJEg
	IRQ_WAIT		thread_wait;	// kernel-thread 荞ݑ҂
	UINT32			event;		// Cxg
	UINT32			(*event_handler[SD_CS_CLIENT_MAX])(UINT32 event);	// NCAghCoCxgnh֐|C^
	int			fd;		// sNCAg
	USHORT			insert;		// J[hE(CardManagerΉ͕sv)
	ULONG			log_level;	// Ox
	MAKE_ERR		make_err;	// G[v
	struct	timeval 	in_tv;		// Ԍvp
	struct	timeval 	out_tv;		// Ԍvp
	ULONG			in_oscr;	// Ԍvp (OSCR:OS Timer Counter Register  3.6864MHz)
	ULONG			out_oscr;	// Ԍvp (OSCR:OS Timer Counter Register  3.6864MHz)
	UCHAR			pnp_info1;

} STR_SDIF_INTERNAL_DRIVER;

/***************************************/
/* e}N                          */
/***************************************/
extern STR_SDIF_INTERNAL_DRIVER gSDStatus;
extern SDD_HANDLE *ptSDD_Handle_Nor;
extern SDD_HANDLE *ptSDD_Handle_Sec;

#define SD_CS_LOCK      down(&gSDStatus.client_sem)     // Z}tHl
#define SD_CS_UNLOCK    up(&gSDStatus.client_sem)       // Z}tHJ


/***********************************************************/
/* Ovg^Cv錾                                    */
/***********************************************************/
/* S̈J[hTCY擾iSD_IOC_GET_CARDSIZEj */
ULONG	SD_P_IocGetCardSize(ULONG ulArg);
/* ʏ̈J[hTCY擾iSD_IOC_GET_NOMSIZEj */
ULONG	SD_P_IocGetNomSize(ULONG ulArg);
/* CgveNg`FbNiSD_IOC_GET_WP_CHECKj */
ULONG	SD_P_Ioc_WP_Check(ULONG ulArg);
/* J[hiSD_IOC_SET_INITj */
ULONG	SD_P_Ioc_MPInit(ULONG ulArg);
/* ݃nhe[uo^iSD_IOC_REQUEST_IRQj */
ULONG	SD_P_IocRequestIrq(ULONG ulArg);
/* ݃nhe[uiSD_IOC_FREE_IRQj */
ULONG	SD_P_IocFreeIrq(ULONG ulArg);
/* J[hXe[^X擾iSD_IOC_GET_STATUSj */
ULONG	SD_P_IocGetStatus(ULONG ulArg);
/* J[hhCo擾iSD_IOC_GET_INFOj */
ULONG	SD_P_IocGetInfo( ULONG ulArg);
/* ^C}[X^[giSD_IOC_SET_TIMER_STARTj */
ULONG	SD_P_Ioc_TimerStart(ULONG ulArg);
/* ^C}[XgbviSD_IOC_SET_TIMER_STOPj */
ULONG	SD_P_Ioc_TimerStop(ULONG ulArg);
/* J[h}roEna/DisݒiSD_IOC_SET_INSDEL_INTRj */
ULONG	SD_P_Ioc_InsDel_Intr(ULONG ulArg);
/* CMD48 Extension Register Reads */
ULONG	SD_P_IocReadExtrSingle( ULONG ulArg);
/* CMD49 Extension Register Writes */
ULONG	SD_P_IocWriteExtrSingle( ULONG ulArg);

#ifdef _SDD_FUNC_SECURE_
#endif /* _SDD_FUNC_SECURE_ */

#ifdef SDIO
/* CMD52 ReadsiSD_IOC_SET_IO_READ_DIRECTj */
ULONG	SD_P_IocSetIoReadDirect( ULONG ulArg );
/* CMD52 WritesiSD_IOC_SET_IO_WRITE_DIRECTj */
ULONG	SD_P_IocSetIoWriteDirect( ULONG ulArg );
/* R5X|X擾iSD_IOC_GET_IO_R5j */
ULONG	SD_P_IocGetIoR5( ULONG ulArg );
/* CMD53 ReadsiSD_IOC_SET_IO_READ_EXTENDEDj */
ULONG	SD_P_IocSetIoReadExtended( ULONG ulArg );
/* CMD53 WritesiSD_IOC_SET_IO_WRITE_EXTENDEDj */
ULONG	SD_P_IocSetIoWriteExtended( ULONG ulArg );
/* J[hԂINACTIVE֑JځiSD_IOC_SET_IO_GO_INACTIVEj */
ULONG	SD_P_IocSetIoGoInactive( ULONG ulArg );
/* J[he@\gp^sgpݒiSD_IOC_SET_IO_FUNC_ENABLEj */
ULONG	SD_P_IocSetIoFuncEnable( ULONG ulArg );
/* J[he@\Ԏ擾iSD_IOC_GET_IO_FUNCREADYj */
ULONG	SD_P_IocGetIoFuncReady( ULONG ulArg );
/* J[h擾iSD_IOC_GET_IO_STATUSj */
ULONG	SD_P_IocGetIoStatus(ULONG ulArg);
/* SDoXݒ(SD_IOC_SET_IO_BUSWIDTH) */
ULONG	SD_P_IocSetIoBusWidth(ULONG ulArg);
/* CMD53ubN][hf[^ */
ULONG	SD_P_IocSetIoBlockLength(ULONG ulArg);
#endif	//SDIO

#if 1	/* SDRAgݍ	*/
#ifdef _SDD_C2_
#endif /* _SDD_C2_ */
#endif	/* SDRAgݍ	*/

#if 0
ULONG	SD_P_IocSetReadPre(ULONG ulArg);	/* [hO֐ */
ULONG	SD_P_IocSetWritePre(ULONG ulArg);	/* CgO֐ */
#endif

#endif /* __SD_IOCTL_H__ */

